﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace WPF_LibrosFamosos
{
    /// <summary>
    /// Lógica de interacción para MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        public MainWindow()
        {
            InitializeComponent();
        }
        CatalogoLibros cat = new CatalogoLibros();
        
        private void Window_Loaded(object sender, RoutedEventArgs e)
        {
            lstAutores.ItemsSource = cat.Autores;
            lstAutores.SelectedIndex = 0;
            lstAutores.DisplayMemberPath = "Nombre";
            cat.ActualizarLista += Cat_ActualizarLista;
            cat.ActualizarListaLibros += Cat_ActualizarListaLibros;
        }

        private void Cat_ActualizarListaLibros()
        {
            dtgObras.ItemsSource = cat.LibrosAutor((lstAutores.SelectedItem as autores).IdAutor);
        }

        private void Cat_ActualizarLista()
        {
            lstAutores.ItemsSource = null;
            lstAutores.ItemsSource = cat.Autores;
            lstAutores.SelectedIndex = 0;
        }

        private void lstAutores_SelectionChanged(object sender, SelectionChangedEventArgs e)
        {
            if (lstAutores.SelectedItem != null)
            {
                dtgObras.ItemsSource = cat.LibrosAutor((lstAutores.SelectedItem as autores).IdAutor);
            }
        }

        private void btnAgregar_Click(object sender, RoutedEventArgs e)
        {
            try
            {
                autores a = new autores();
                vtnAgregar agregar = new vtnAgregar { DataContext = a };
                bool? resp = agregar.ShowDialog();
                if (resp == true)
                {
                    cat.Agregar(a);
                }
            }
            catch (ArgumentException ag)
            {
                MessageBox.Show(ag.Message, "Advertencia", MessageBoxButton.OK, MessageBoxImage.Exclamation);
            }
            
        }

        private void btnEliminar_Click(object sender, RoutedEventArgs e)
        {
            try
            {
                if (lstAutores.SelectedItem != null)
                {
                    if (MessageBox.Show("Se perderan todos los datos del Autor selccionado.", "Atencion", MessageBoxButton.YesNo, MessageBoxImage.Warning) == MessageBoxResult.Yes)
                    {
                        cat.Eliminar((autores)lstAutores.SelectedItem);
                    }
                }
            }
            catch (ArgumentException ar)
            {
                MessageBox.Show(ar.Message,"Advertencia",MessageBoxButton.OK,MessageBoxImage.Exclamation);
            }
        }

        private void btnEditar_Click(object sender, RoutedEventArgs e)
        {
            try
            {
                if (lstAutores.SelectedItem != null)
                {
                    autores a = lstAutores.SelectedItem as autores;
                    vtnEditarAutor editar = new vtnEditarAutor(cat);
                    editar.DataContext = a;
                    bool? resp = editar.ShowDialog();
                    if (resp == true)
                    {
                        cat.Editar(a);
                    }
                }
            }
            catch (ArgumentException ag)
            {
                MessageBox.Show(ag.Message, "Advertencia", MessageBoxButton.OK, MessageBoxImage.Exclamation);
            }
        }

        private void imgEliminar_MouseLeftButtonDown(object sender, MouseButtonEventArgs e)
        {
            try
            {
                if (MessageBox.Show("Se perderan todos los datos del Libro seleccionado", "Advertencia", MessageBoxButton.YesNo, MessageBoxImage.Warning) == MessageBoxResult.Yes)
                {
                    libros l = ((FrameworkElement)sender).DataContext as libros;
                    resenhas r = l.resenhas;
                    cat.EliminarLibro(l, r);
                }
            }
            catch (ArgumentException mensaje)
            {
                MessageBox.Show(mensaje.Message, "Advertencia", MessageBoxButton.OK, MessageBoxImage.Exclamation);
            }
        }

        private void ImgEditar_MouseLeftButtonDown(object sender, MouseButtonEventArgs e)
        {
            try
            {
                if (dtgObras.SelectedItem != null)
                {
                    libros libro = ((FrameworkElement)sender).DataContext as libros;
                    vtnEditarLibro editar = new vtnEditarLibro(cat);
                    editar.DataContext = libro;
                    resenhas rese;
                    if (libro.resenhas == null)
                    {
                        rese = new resenhas();
                    }
                    else
                    {
                        rese = libro.resenhas;
                    }
                    editar.txtResena.DataContext = rese;
                    editar.cmbAutores.ItemsSource = cat.Autores;
                    editar.ShowDialog();
                }
            }
            catch (ArgumentException ar)
            {
                MessageBox.Show(ar.Message, "Advertencia", MessageBoxButton.OK, MessageBoxImage.Exclamation);
            }
        }

        private void btnAgregarLibro_Click(object sender, RoutedEventArgs e)
        {
            try
            {
                libros l = new libros();
                resenhas r = new resenhas();
                vtnAgregarLibro vtnAgregar = new vtnAgregarLibro(cat);
                vtnAgregar.DataContext = l;
                vtnAgregar.txtReseña.DataContext = r;
                bool? resp = vtnAgregar.ShowDialog();
                if (resp == true)
                {
                    cat.AgregarLibro(l, r);
                }
            }
            catch (ArgumentException ar)
            {
                MessageBox.Show(ar.Message, "Advertencia", MessageBoxButton.OK, MessageBoxImage.Exclamation);
            }
        }

        private void btnInformation_MouseLeftButtonDown(object sender, MouseButtonEventArgs e)
        {
            try
            {
                wndLibros lib = new wndLibros();
                libros libro = ((FrameworkElement)sender).DataContext as libros;
                lib.DataContext = libro;
                lib.txtTitulo.Text = libro.Titulo;
                lib.txtTituloOriginal.Text = libro.TituloOriginal;
                lib.txtReseña.Text = cat.Reseña(libro.Id);
                lib.ShowDialog();
            }
            catch (ArgumentException ar)
            {
                MessageBox.Show(ar.Message, "Advertencia", MessageBoxButton.OK, MessageBoxImage.Exclamation);
            }
        }
    }
}
